<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BiodataModel;

class BiodataController extends BaseController
{
    protected $biodataModel;

    public function __construct()
    {
        $this->biodataModel = new BiodataModel();
    }

    public function index()
    {
        // Untuk portfolio personal, hanya ada satu biodata
        // Jika sudah ada, langsung edit. Jika belum, buat baru
        $biodata = $this->biodataModel->first();

        if ($biodata) {
            // Jika sudah ada biodata, redirect ke edit
            return redirect()->to('admin/biodata/edit');
        } else {
            // Jika belum ada, redirect ke create
            return redirect()->to('admin/biodata/create');
        }
    }

    public function create()
    {
        $data = [
            'title' => 'Tambah Biodata'
        ];
        return view('admin/biodata/create', $data);
    }

    public function store()
    {
        $rules = [
            'nama_lengkap' => 'required|min_length[3]|max_length[200]',
            'email' => 'permit_empty|valid_email|max_length[100]',
            'foto_profil' => 'permit_empty|uploaded[foto_profil]|max_size[foto_profil,2048]|ext_in[foto_profil,jpg,jpeg,png,gif]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $fileFoto = $this->request->getFile('foto_profil');
        $fotoName = null;

        if ($fileFoto && $fileFoto->isValid() && !$fileFoto->hasMoved()) {
            $fotoName = $fileFoto->getRandomName();
            $fileFoto->move(FCPATH . 'assets/uploads/biodata/', $fotoName);
        }

        $data = [
            'nama_lengkap' => $this->request->getPost('nama_lengkap'),
            'nama_panggilan' => $this->request->getPost('nama_panggilan'),
            'tempat_lahir' => $this->request->getPost('tempat_lahir'),
            'tanggal_lahir' => $this->request->getPost('tanggal_lahir'),
            'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
            'alamat' => $this->request->getPost('alamat'),
            'kota' => $this->request->getPost('kota'),
            'provinsi' => $this->request->getPost('provinsi'),
            'kode_pos' => $this->request->getPost('kode_pos'),
            'no_telepon' => $this->request->getPost('no_telepon'),
            'email' => $this->request->getPost('email'),
            'website' => $this->request->getPost('website'),
            'linkedin' => $this->request->getPost('linkedin'),
            'github' => $this->request->getPost('github'),
            'instagram' => $this->request->getPost('instagram'),
            'foto_profil' => $fotoName,
            'tentang_saya' => $this->request->getPost('tentang_saya'),
            'keahlian' => $this->request->getPost('keahlian')
        ];

        // Cek apakah sudah ada biodata
        $existingBiodata = $this->biodataModel->first();
        if ($existingBiodata) {
            return redirect()->to('admin/biodata/edit')->with('error', 'Biodata sudah ada! Gunakan fitur edit untuk mengubah biodata.');
        }

        if ($this->biodataModel->insert($data)) {
            return redirect()->to('admin/biodata/edit')->with('success', 'Biodata berhasil ditambahkan!');
        } else {
            return redirect()->back()->withInput()->with('error', 'Gagal menambahkan biodata!');
        }
    }

    public function edit()
    {
        // Untuk portfolio personal, hanya ada satu biodata
        $biodata = $this->biodataModel->first();
        
        if (!$biodata) {
            // Jika belum ada, redirect ke create
            return redirect()->to('admin/biodata/create')->with('info', 'Biodata belum ada. Silakan buat biodata terlebih dahulu.');
        }

        $data = [
            'title' => 'Edit Biodata / CV',
            'biodata' => $biodata
        ];
        return view('admin/biodata/edit', $data);
    }

    public function update()
    {
        // Untuk portfolio personal, hanya ada satu biodata
        $biodata = $this->biodataModel->first();
        
        if (!$biodata) {
            return redirect()->to('admin/biodata/create')->with('error', 'Biodata tidak ditemukan! Silakan buat biodata terlebih dahulu.');
        }
        
        $id = $biodata['id'];

        $rules = [
            'nama_lengkap' => 'required|min_length[3]|max_length[200]',
            'email' => 'permit_empty|valid_email|max_length[100]',
            'foto_profil' => 'permit_empty|uploaded[foto_profil]|max_size[foto_profil,2048]|ext_in[foto_profil,jpg,jpeg,png,gif]'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
        }

        $fileFoto = $this->request->getFile('foto_profil');
        
        $data = [
            'nama_lengkap' => $this->request->getPost('nama_lengkap'),
            'nama_panggilan' => $this->request->getPost('nama_panggilan'),
            'tempat_lahir' => $this->request->getPost('tempat_lahir'),
            'tanggal_lahir' => $this->request->getPost('tanggal_lahir'),
            'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
            'alamat' => $this->request->getPost('alamat'),
            'kota' => $this->request->getPost('kota'),
            'provinsi' => $this->request->getPost('provinsi'),
            'kode_pos' => $this->request->getPost('kode_pos'),
            'no_telepon' => $this->request->getPost('no_telepon'),
            'email' => $this->request->getPost('email'),
            'website' => $this->request->getPost('website'),
            'linkedin' => $this->request->getPost('linkedin'),
            'github' => $this->request->getPost('github'),
            'instagram' => $this->request->getPost('instagram'),
            'tentang_saya' => $this->request->getPost('tentang_saya'),
            'keahlian' => $this->request->getPost('keahlian')
        ];

        if ($fileFoto && $fileFoto->isValid() && !$fileFoto->hasMoved()) {
            if ($biodata['foto_profil'] && file_exists(FCPATH . 'assets/uploads/biodata/' . $biodata['foto_profil'])) {
                unlink(FCPATH . 'assets/uploads/biodata/' . $biodata['foto_profil']);
            }
            $fotoName = $fileFoto->getRandomName();
            $fileFoto->move(FCPATH . 'assets/uploads/biodata/', $fotoName);
            $data['foto_profil'] = $fotoName;
        }

        if ($this->biodataModel->update($id, $data)) {
            return redirect()->to('admin/biodata/edit')->with('success', 'Biodata berhasil diupdate!');
        } else {
            return redirect()->back()->withInput()->with('error', 'Gagal mengupdate biodata!');
        }
    }
}

